%Example: Run a simulation with a heavy-duty conventional vehicle
clear

%% Create a vehicle configuration, load the mission
conf = vehConf('bev');
conf.vehicle_name = "S-Way";
conf.finalDrive_name = "VECTO_2_59";
conf.transmission_name = "VECTO_AMT_3speeds";
conf.em_name = "ASM_125kW";
conf.battery_name = "NMC";

% Create the vehicle data using createConfiguration
veh = createVehicle(conf);

veh.batt = scaleBatt(veh.batt, 500, 700);
veh.em = scaleEMachine(veh.em, 375);

% Select the mission. This must be an existing .mat file in the library
mission_name = "LongHaul";

%% Run simulation
[results, veh, prof, info] = vehicleSim(veh, mission_name);

%% Plot
% Plot default profiles as a function of traveled distance
mainProfiles(prof, veh, "def", "dist");

% Plot e-machine operating points
emMapOperation(veh.em, prof, 'loss')